/*! \file    
**********************************************************************************	
* Title:						Discretix SST MM API Source file						 					
*																			
* Filename:						sst_api_mm.c															
*																			
* Project, Target, subsystem:	SST 6.0, utility, API
* 
* Created:						17.08.2007														
*								
* Modified:						17.08.2007										
*								
* \Author						Miri S														
*																			
* \Remarks						
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/*----------- External include files ----------------------------------------*/
#include "DX_VOS_Mem.h"
#include "sst_host_op_code.h"
#include "dx_hw_defs.h"
/*----------- Local include files -------------------------------------------*/
#include "sst_mm.h"


/*---------------------------------------------------------------------------*/
/*               API FUNCTIONS                                               */
/*---------------------------------------------------------------------------*/


/* SST_MMGet */
DxError_t SST_MMGet(SSTMode_t *aCurrentMode_ptr)
{    

	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_MM_GET, 1,
	   							 /* PARAMETERS: */
                                 aCurrentMode_ptr );
}

/* SST_MMSet */
DxError_t SST_MMSet(SSTMode_t aNewMode)
{   
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_MM_SET, 1,
	   							 /* PARAMETERS: */
                                 aNewMode );
}

/* SST_MMAuthSet */
DxError_t SST_MMAuthSet(SSTTxnId_t          aTransactionId,  
                        SSTHandle_t         aAuthHandle,
                        SSTMode_t           aNewMode,                        
                        DxByte_t           *aWorkspace_ptr,
                        DxUint32_t          aWorkspaceSizeInBytes)
{  
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_MM_AUTH_SET, 6,
	   							 /* PARAMETERS: */
                                aTransactionId,  
                                aAuthHandle,
                                aNewMode,                        
                                aWorkspace_ptr,
                                aWorkspaceSizeInBytes );
}

/* SST_MMPrivAuthCreate */
DxError_t SST_MMPrivAuthCreate(SSTTxnId_t          aTransactionId,
                               SSTSessionId_t      aSessionId,
                               SSTHandle_t        *aAuthHandle_ptr,                        
                               DxByte_t           *aWorkspace_ptr,
                               DxUint32_t          aWorkspaceSizeInBytes)
{  
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_MM_PRIV_AUTH_CREATE, 5,
	   							 /* PARAMETERS: */
                                   aTransactionId,
                                   aSessionId,
                                   aAuthHandle_ptr,                        
                                   aWorkspace_ptr,
                                   aWorkspaceSizeInBytes );
}


/* SST_MMPrivAuthOpen */
DxError_t SST_MMPrivAuthOpen(SSTSessionId_t    aSessionId,
                             SSTHandle_t       aAuthHandle,                        
                             DxByte_t         *aWorkspace_ptr,
                             DxUint32_t        aWorkspaceSizeInBytes)
{  
    
	return DX_HW_Dispatcher_ptr( SST_SEP_OP_CODE_MM_PRIV_AUTH_OPEN, 5,
	   							 /* PARAMETERS: */
                                 aSessionId,
                                 aAuthHandle,                        
                                 aWorkspace_ptr,
                                 aWorkspaceSizeInBytes );
}


